!Object constantsFor: 'Geos Libraries'!

geosLIB16 'SYSTEM\contdb'! !

!Object constantsFor: 'Geos vardata'!

attrContactEditNoFieldDataAllowed 27648!
attrContactEditRecordWasEmpty 27652!
tempContactEditDbHandle 27656!
attrContactEditRecoverFromState 27660!
attrContactEditCtrlnpSaveAllowed 27664!
tempContactEditRecordModified 27668!
tempContactEditOriginalBlockSize 27672!
attrContactEditShowRecordImage 27676!
attrContactListMoniker 27648!
attrContactListStatusMsg 27652!
tempContactListTabBounds 27656!
tempContactListDoNotSendNotifications 27660!
attrContactListCallType 27664!
attrContactListNotifyContactSelectedMsg 27668!
tempContactListSelectedContact 27672!
tempContactListPreserveSearch 27676!
attrContactListNumItems 27680!
hintContactListNonExclusiveList 27684!
attrContactListNotifyNumberEnteredMsg 27688!
attrContactListEmergencyNumbers 27692!
attrContactListAlternateNotifyContactSelectedMsg 27696!
attrContactListAlternateNotifyNumberEnteredMsg 27700!
tempContactListAlternateSelectionMode 27704!
tempContactListSelectedInfo 27708!
attrContactListNotifyMultipleContactsSelectedMsg 27712!
attrContactListAlternateNotifyMultipleContactsSelectedMsg 27716!
attrContactListAttachDetailsView 27720!
attrContactListShowMemoryCard 27724!
tempContactListAlternateLineText 27728!
attrContactListLimitingGroupId 27732!
hintContactListDontAddDefaultHints 27736!
attrContactListDontAllowRecords 27740!
attrContactListAllowGroupAsCallType 27744!
hintContactListNoSecondColumn 27748!
attrContactSimListCallType 27648!
attrContactSimListStatusMsg 27652!
attrContactSimListNotifyContactSelectedMsg 27656!
attrContactSimListAlternateNotifyContactSelectedMsg 27660!
attrContactSimListNotifyMultipleContactsSelectedMsg 27664!
attrContactSimListAlternateNotifyMultipleContactsSelectedMsg 27668!
attrContactSimListNotifyNumberEnteredMsg 27672!
attrContactSimListAlternateNotifyNumberEnteredMsg 27676!
attrContactSimListEmergencyNumbers 27680!
hintContactSimListNonExclusiveList 27684!
hintContactSimListNotifyOnFocusChange 27688!
hintContactSimListStartInLocationOrder 27692!
hintContactSimListDoNotDisplayLocationNumbers 27696!
tempContactSimListAlternateSelectionMode 27700!
tempContactSimListAlternateLineText 27704!
tempSpeedDialDbHandle 27648!
!

!Object constantsFor: 'Geos messages'!

editDisplayRecord 27648!
editDeleteRecord 27649!
editSaveRecordData 27650!
editSaveRecordDataSilently 27651!
editSetSecretStatus 27652!
editSetRingingTone 27653!
editAddField 27654!
editAddFieldTypeSelected 27655!
editDeleteField 27656!
editChangeFieldLabel 27657!
editFieldHasFocus 27658!
editInitiateAddFieldDialog 27659!
editGetChangeFieldLabelMoniker 27660!
editChangeLabelOfFocusedField 27661!
editFieldLabelSelected 27662!
editInitiateOptionsDialog 27663!
editMarkModified 27664!
editCorrectTelHalfLines 27665!
editCorrectFaxHalfLines 27666!
editAddFieldSpeedDial 27667!
editSaveAndClose 27668!
editGetRecordHandle 27669!
editSetFocusToTopField 27670!
editInitiateMenuDialog 27671!
editDisplayNextRecord 27672!
editDisplayPreviousRecord 27673!
editCopyRecord 27674!
editCopyFieldsToClipboard 27675!
editCorrectTelFaxHalfLines 27676!
editCorrectTelDataHalfLines 27677!
editFetchUrl 27678!
editSetSelectionToTopField 27679!
editInitiateRealOptionsDialog 27680!
editSetImageName 27681!
editSetRingingToneName 27682!
editShowGroups 27683!
groupListInit 27648!
listQueryEntryMoniker 27648!
listSelectionChanged 27649!
listSearchTextLostFocus 27650!
listGetIdOfSelectedRecord 27651!
listSearchTextTimeoutMsg 27652!
listQueryNumberListMoniker 27653!
listSelectCurrentContact 27654!
listSelectContactNumber 27655!
listCloseContactNumberPopup 27656!
listHandleSelectionChangeNotification 27657!
listCompleteSearch 27658!
listPreserveSearchOnNextLostFocus 27659!
listGetIdsOfSelectedRecords 27660!
listNotifyContactSelected 27661!
listAlternateNotifyContactSelected 27662!
listCancelContactNumberPopup 27663!
listSetEmergencyNumbers 27664!
listGetSearchResults 27665!
listSearchTextGainedFocus 27666!
listSetAlternateLineText 27667!
listLimitToGroup 27668!
listGetGroupLimit 27669!
listDoGroupSearch 27670!
listGetCurrentDbName 27671!
listGetSelectionAndDbNames 27672!
listGetVisibleOrderOfSelectedRecord 27673!
listGetVisibleOrdersOfSelectedRecords 27674!
parentGroupListSetRecordid 27648!
parentGroupListReset 27649!
simEditDisplayLocation 27648!
simEditGetFieldLengths 27649!
simEditSaveIfModified 27650!
simEditGetNthEmptyLocation 27651!
simEditQueryEmptyMoniker 27652!
simListGetSelectedLocation 27648!
simListGetSelectedLocationsList 27649!
simListClearSelectedEntries 27650!
simListCopyContactRecordsToSim 27651!
simListCopyListFromContacts 27652!
simListGetNameSortedStatus 27653!
simListSetNameSortedStatus 27654!
simListSetEmergencyNumbers 27655!
simListQueryUserMoniker 27656!
simListSearchEntries 27657!
simListSetFocusByLocation 27658!
simListSelectionChanged 27659!
simListNotifyContactSelected 27660!
simListAlternateNotifyContactSelected 27661!
simListSelectCurrentContact 27662!
simListCurSelTimerSendNow 27663!
simListCurSelTimerTimeoutMsg 27664!
simListGainedFocus 27665!
simListLostFocus 27666!
simListSetAlternateLineText 27667!
dialQueryListEntry 27648!
dialOpenList 27649!
dialReplaceEntry 27650!
dialDisplayContact 27651!
!

!Geos class methodsFor: 'library calls'!

ContactSIMGetCacheStatus
	"ContactSIMError pascal ContactSIMGetCacheStatus(void) in contsim.goh"
	^GEOS call: #[16 0 108 1]!

ContactSIMFetchContacts
	"Boolean pascal ContactSIMFetchContacts(void) in contsim.goh"
	^GEOS call: #[16 0 107 4]!

ContactSIMNumber: totalSIMContacts with: usedSIMContacts
	"ContactSIMError pascal ContactSIMNumber(word *totalSIMContacts, word *usedSIMContacts ) in contsim.goh"
	^GEOS call: totalSIMContacts with: usedSIMContacts with: #[16 0 109 3 3 1]!

ContactSIMGetLocationEntry: location with: name with: number
	"ContactSIMError pascal ContactSIMGetLocationEntry(word location, TCHAR *name, TCHAR *number ) in contsim.goh"
	^GEOS call: location with: name with: number with: #[16 0 110 1 3 3 1]!

ContactSIMGetSortedEntry: sortOrder with: name with: number
	"ContactSIMError pascal ContactSIMGetSortedEntry(word sortOrder, TCHAR *name, TCHAR *number ) in contsim.goh"
	^GEOS call: sortOrder with: name with: number with: #[16 0 111 1 3 3 1]!

ContactSIMCheckLocationEmpty: location
	"Boolean pascal ContactSIMCheckLocationEmpty(word location) in contsim.goh"
	^GEOS call: location with: #[16 0 113 1 4]!

ContactSIMCheckLocationHasNumber: location
	"Boolean pascal ContactSIMCheckLocationHasNumber(word location) in contsim.goh"
	^GEOS call: location with: #[16 0 115 1 4]!

ContactSIMCheckSIMStatus
	"Boolean pascal ContactSIMCheckSIMStatus(void) in contsim.goh"
	^GEOS call: #[16 0 118 4]!

ContactSIMGetFirstEmptyLocation
	"word pascal ContactSIMGetFirstEmptyLocation(void) in contsim.goh"
	^GEOS call: #[16 0 120 1]!

ContactSIMXlatToLocation: sortOrder
	"word pascal ContactSIMXlatToLocation(word sortOrder) in contsim.goh"
	^GEOS call: sortOrder with: #[16 0 124 1 1]!

ContactSIMXlatToSortOrder: location
	"word pascal ContactSIMXlatToSortOrder(word location) in contsim.goh"
	^GEOS call: location with: #[16 0 126 1 1]!

ContactSIMCheckFDNStatus
	"Boolean pascal ContactSIMCheckFDNStatus(void) in contsim.goh"
	^GEOS call: #[16 0 152 4]!

ContactGetDBHandle
	"VMFileHandle pascal ContactGetDBHandle(void) in contdb.h"
	^GEOS call: #[16 0 1 1]!

ContactGetDBHandleNoBlock
	"VMFileHandle pascal ContactGetDBHandleNoBlock(void) in contdb.h"
	^GEOS call: #[16 0 7 1]!

ContactReleaseDBHandle
	"void pascal ContactReleaseDBHandle(void) in contdb.h"
	^GEOS call: #[16 0 10 0]!

ContactCloseDBFile
	"word pascal ContactCloseDBFile(void) in contdb.h"
	^GEOS call: #[16 0 8 1]!

ContactReOpenDBFile
	"VMFileHandle pascal ContactReOpenDBFile(void) in contdb.h"
	^GEOS call: #[16 0 9 1]!

ContactCreateRecordFromTemplate
	"MemHandle pascal ContactCreateRecordFromTemplate(void) in contdb.h"
	^GEOS call: #[16 0 2 1]!

ContactEnsureField: record with: fieldName with: fieldType
	"FieldID pascal ContactEnsureField(MemHandle record, optr fieldName, ContdbFieldType fieldType) in contdb.h"
	^GEOS call: record with: fieldName with: fieldType with: #[16 0 21 1 2 1 1]!

ContactEnsureEmptyField: record with: fieldName with: fieldType
	"FieldID pascal ContactEnsureEmptyField(MemHandle record, optr fieldName, ContdbFieldType fieldType) in contdb.h"
	^GEOS call: record with: fieldName with: fieldType with: #[16 0 32 1 2 1 1]!

ContactSetTemplateRecord: record
	"void pascal ContactSetTemplateRecord(MemHandle record) in contdb.h"
	^GEOS call: record with: #[16 0 4 1 0]!

ContactSaveRecord: record
	"dword pascal ContactSaveRecord(MemHandle record) in contdb.h"
	^GEOS call: record with: #[16 0 6 1 2]!

ContactGetUserDataID
	"dword pascal ContactGetUserDataID(void) in contdb.h"
	^GEOS call: #[16 0 19 2]!

ContactGetUserDataName: username with: bufSize
	"word pascal ContactGetUserDataName(TCHAR *username, word bufSize) in contdb.h"
	^GEOS call: username with: bufSize with: #[16 0 48 3 1 1]!

ContactMatchNumber: number with: type with: field with: numMatches
	"RecordID pascal ContactMatchNumber(TCHAR *number, ContdbCallType type, FieldID *field, word *numMatches) in contdb.h"
	^GEOS call: number with: type with: field with: numMatches with: #[16 0 16 3 1 3 3 2]!

ContactMatchName: name with: type with: stopEarly with: field with: numMatches
	"RecordID pascal ContactMatchName(TCHAR *name, ContdbFieldType type, Boolean stopEarly, FieldID *field, word *numMatches) in contdb.h"
	^GEOS call: name with: type with: stopEarly with: field with: numMatches with: #[16 0 34 3 1 4 3 3 2]!

ContactGetName: record with: dest
	"Boolean pascal ContactGetName(MemHandle record, TCHAR *dest) in contdb.h"
	^GEOS call: record with: dest with: #[16 0 18 1 3 4]!

ContactGetTruncatedName: record with: dest with: destSize
	"Boolean pascal ContactGetTruncatedName(MemHandle record, TCHAR *dest, word destSize) in contdb.h"
	^GEOS call: record with: dest with: destSize with: #[16 0 36 1 3 1 4]!

SpeedDialGetSlot: rid with: fid
	"int pascal SpeedDialGetSlot(RecordID rid, FieldID fid) in contdb.h"
	^GEOS call: rid with: fid with: #[16 0 29 2 1 4]!

SpeedDialGetRecord: slot with: rid with: fid
	"int pascal SpeedDialGetRecord(int slot, RecordID *rid, FieldID *fid) in contdb.h"
	^GEOS call: slot with: rid with: fid with: #[16 0 27 4 3 3 4]!

SpeedDialSetRecord: slot with: rid with: fid
	"int pascal SpeedDialSetRecord(int slot, RecordID rid, FieldID fid) in contdb.h"
	^GEOS call: slot with: rid with: fid with: #[16 0 28 4 2 1 4]!

SpeedDialGetNumber: slot with: buf
	"int pascal SpeedDialGetNumber(int slot, TCHAR *buf) in contdb.h"
	^GEOS call: slot with: buf with: #[16 0 30 4 3 4]!

ContactImportDBFromTextFile: fileImport
	"void pascal ContactImportDBFromTextFile(hptr fileImport) in contdb.h"
	^GEOS call: fileImport with: #[16 0 41 1 0]!

ContactImportDBFromTextFileStatus: fileImport
	"ContactExportStatus pascal ContactImportDBFromTextFileStatus(hptr fileImport) in contdb.h"
	^GEOS call: fileImport with: #[16 0 145 1 1]!

ContactExportDBToTextFile: fileExport with: startElement with: numOfRecords
	"ContactExportStatus pascal ContactExportDBToTextFile(hptr fileExport, dword startElement, dword numOfRecords) in contdb.h"
	^GEOS call: fileExport with: startElement with: numOfRecords with: #[16 0 42 1 2 2 1]!

ContdbRecreateFieldLabel: subLabel with: destination with: fieldType
	"void pascal ContdbRecreateFieldLabel(TCHAR *subLabel, TCHAR *destination, int fieldType) in contdb.h"
	^GEOS call: subLabel with: destination with: fieldType with: #[16 0 44 3 3 4 0]!

ContdbTranslateSubFieldLabelToEnglish: subLabel with: destination
	"void pascal ContdbTranslateSubFieldLabelToEnglish(TCHAR *subLabel, TCHAR *destination) in contdb.h"
	^GEOS call: subLabel with: destination with: #[16 0 43 3 3 0]!

ContactCompareNumbers: number1 with: number2
	"Boolean pascal ContactCompareNumbers(TCHAR *number1, TCHAR *number2) in contdb.h"
	^GEOS call: number1 with: number2 with: #[16 0 46 3 3 4]!

ContactChangeNetworkVersion: cnvt
	"void pascal ContactChangeNetworkVersion(ContactNetworkVersionType cnvt) in contdb.h"
	^GEOS call: cnvt with: #[16 0 50 1 0]!

ContactVerifyNetworkVersion
	"void pascal ContactVerifyNetworkVersion(void) in contdb.h"
	^GEOS call: #[16 0 57 0]!

ContactGetDBName: dbIndex with: dbName
	"int pascal ContactGetDBName(int dbIndex, TCHAR *dbName) in contdb.h"
	^GEOS call: dbIndex with: dbName with: #[16 0 64 4 3 4]!

ContactChangeStandardDB: dbName
	"int pascal ContactChangeStandardDB(TCHAR *dbName) in contdb.h"
	^GEOS call: dbName with: #[16 0 65 3 4]!

ContactSetOverrideDB: dbName
	"word pascal ContactSetOverrideDB(TCHAR *dbName) in contdb.h"
	^GEOS call: dbName with: #[16 0 67 3 1]!

ContactRemoveOverrideDB: void
	"void pascal ContactRemoveOverrideDB(void ) in contdb.h"
	^GEOS call: void with: #[16 0 68 0]!

ContactRestoreOverrideDB: dbToken
	"void pascal ContactRestoreOverrideDB(word dbToken ) in contdb.h"
	^GEOS call: dbToken with: #[16 0 139 1 0]!

ContactCreateNewDB: dbName
	"word pascal ContactCreateNewDB(TCHAR *dbName) in contdb.h"
	^GEOS call: dbName with: #[16 0 66 3 1]!

ContactGetNumDBsOnMemoryCard
	"int pascal ContactGetNumDBsOnMemoryCard(void) in contdb.h"
	^GEOS call: #[16 0 69 4]!

ContactGetMemCardStatus
	"int pascal ContactGetMemCardStatus(void) in contdb.h"
	^GEOS call: #[16 0 71 4]!

ContactGetImageFile: recordID with: imageLocation
	"ContactImageFileType pascal ContactGetImageFile(RecordID recordID, TCHAR *imageLocation) in contdb.h"
	^GEOS call: recordID with: imageLocation with: #[16 0 74 2 3 1]!

ContactSetImageFile: recordID with: imageLocation
	"ContactImageFileType pascal ContactSetImageFile(RecordID recordID, TCHAR *imageLocation) in contdb.h"
	^GEOS call: recordID with: imageLocation with: #[16 0 75 2 3 1]!

ContactGetToneFile: recordID with: toneLocation
	"ContactToneFileType pascal ContactGetToneFile(RecordID recordID, TCHAR *toneLocation) in contdb.h"
	^GEOS call: recordID with: toneLocation with: #[16 0 89 2 3 1]!

ContactSetToneFile: recordID with: toneLocation
	"ContactToneFileType pascal ContactSetToneFile(RecordID recordID, TCHAR *toneLocation) in contdb.h"
	^GEOS call: recordID with: toneLocation with: #[16 0 90 2 3 1]!

ContactCreateGroup: groupName
	"RecordID pascal ContactCreateGroup(TCHAR *groupName) in contdb.h"
	^GEOS call: groupName with: #[16 0 77 3 2]!

ContactAddRecordToGroup: childRecord with: group
	"word pascal ContactAddRecordToGroup(RecordID childRecord, RecordID group) in contdb.h"
	^GEOS call: childRecord with: group with: #[16 0 79 2 2 1]!

ContactIsRecordAGroup: record
	"Boolean pascal ContactIsRecordAGroup(Handle record) in contdb.h"
	^GEOS call: record with: #[16 0 81 1 4]!

ContactRemoveRecordFromGroup: recordToRemove with: group
	"void pascal ContactRemoveRecordFromGroup(RecordID recordToRemove, RecordID group) in contdb.h"
	^GEOS call: recordToRemove with: group with: #[16 0 83 2 2 0]!

ContactListGroups: getMemberCount
	"optr pascal ContactListGroups(Boolean getMemberCount ) in contdb.h"
	^GEOS call: getMemberCount with: #[16 0 85 4 2]!

ContactDeleteRecord: record
	"Boolean pascal ContactDeleteRecord(MemHandle record) in contdb.h"
	^GEOS call: record with: #[16 0 148 1 4]!

ContactGetDBDiskHandle
	"DiskHandle pascal ContactGetDBDiskHandle(void) in contdb.h"
	^GEOS call: #[16 0 149 1]!

ContactGetGroupCount
	"word pascal ContactGetGroupCount(void) in contdb.h"
	^GEOS call: #[16 0 150 1]!

ContactCloseDBFilesOnMMC
	"void pascal ContactCloseDBFilesOnMMC(void) in contdb.h"
	^GEOS call: #[16 0 153 0]!

ContactReOpenDBFilesOnMMC
	"void pascal ContactReOpenDBFilesOnMMC(void) in contdb.h"
	^GEOS call: #[16 0 154 0]!

!

GenControl subclass: #ContactEdit
	instanceVariableNames: ''
	classVariableNames: ''!

GenDynamicList subclass: #ContactGroupList
	instanceVariableNames: ''
	classVariableNames: ''!

GenControl subclass: #ContactList
	instanceVariableNames: ''
	classVariableNames: ''!

GenDynamicList subclass: #ContactParentGroupList
	instanceVariableNames: ''
	classVariableNames: ''!

GenControl subclass: #ContactSIMEdit
	instanceVariableNames: ''
	classVariableNames: ''!

GenControl subclass: #ContactSIMList
	instanceVariableNames: ''
	classVariableNames: ''!

GenControl subclass: #SpeedDialControl
	instanceVariableNames: ''
	classVariableNames: ''!

!ContactEdit comment!
Library contdb, file contdb.goh! !

!ContactEdit class methodsFor: 'library linkage'!

library
	^16!

entry
	^13!
!

!ContactEdit methodsFor: 'Geos instance variables'!

ceiRecord
	"@instance MemHandle CEI_record"
	^self wordAt: 25!

ceiRecord: value
	"@instance MemHandle CEI_record"
	^self wordAt: 25 put: value!

ceiRecordID
	"@instance RecordID CEI_recordID"
	^self dwordAt: 27!

ceiRecordID: value
	"@instance RecordID CEI_recordID"
	^self dwordAt: 27 put: value!

!

!ContactEdit methodsFor: 'Geos vardata'!

attrContactEditNoFieldDataAllowed
	"@vardata void ATTR_CONTACT_EDIT_NO_FIELD_DATA_ALLOWED"
	^self addVardata: ##attrContactEditNoFieldDataAllowed!

attrContactEditRecordWasEmpty
	"@vardata void ATTR_CONTACT_EDIT_RECORD_WAS_EMPTY"
	^self addVardata: ##attrContactEditRecordWasEmpty!

tempContactEditDbHandle: value
	"@vardata VMFileHandle TEMP_CONTACT_EDIT_DB_HANDLE"
	^self addVardata: ##tempContactEditDbHandle word: value!

attrContactEditRecoverFromState
	"@vardata ContactEditRecoverData ATTR_CONTACT_EDIT_RECOVER_FROM_STATE"
	^self addVardata: ##attrContactEditRecoverFromState size: 10!

attrContactEditRecoverFromState: aBlock
	"@vardata ContactEditRecoverData ATTR_CONTACT_EDIT_RECOVER_FROM_STATE"
	aBlock value: (GCSContactEditRecoverData forPointer: (self addVardata: ##attrContactEditRecoverFromState size: 10)).!

attrContactEditCtrlnpSaveAllowed
	"@vardata void ATTR_CONTACT_EDIT_CTRLNP_SAVE_ALLOWED"
	^self addVardata: ##attrContactEditCtrlnpSaveAllowed!

tempContactEditRecordModified
	"@vardata void TEMP_CONTACT_EDIT_RECORD_MODIFIED"
	^self addVardata: ##tempContactEditRecordModified!

tempContactEditOriginalBlockSize: value
	"@vardata word TEMP_CONTACT_EDIT_ORIGINAL_BLOCK_SIZE"
	^self addVardata: ##tempContactEditOriginalBlockSize word: value!

attrContactEditShowRecordImage
	"@vardata void ATTR_CONTACT_EDIT_SHOW_RECORD_IMAGE"
	^self addVardata: ##attrContactEditShowRecordImage!

!

!ContactEdit methodsFor: 'Geos messages'!

editDisplayRecord: record
	"@message void MSG_CONTACT_EDIT_DISPLAY_RECORD(MemHandle record = cx)"
	^self geosMessage: #[108 0 2 5 1 0] with: record!

editDeleteRecord
	"@message void MSG_CONTACT_EDIT_DELETE_RECORD()"
	^self geosMessage: #[108 1 2 0 0]!

editSaveRecordData
	"@message void MSG_CONTACT_EDIT_SAVE_RECORD_DATA()"
	^self geosMessage: #[108 2 2 0 0]!

editSaveRecordDataSilently: record
	"@message void MSG_CONTACT_EDIT_SAVE_RECORD_DATA_SILENTLY(MemHandle record = cx)"
	^self geosMessage: #[108 3 2 5 1 0] with: record!

editSetSecretStatus: secretStatus
	"@message void MSG_CONTACT_EDIT_SET_SECRET_STATUS(ContactEditSecretStatus secretStatus = cx)"
	^self geosMessage: #[108 4 2 5 1 0] with: secretStatus!

editSetRingingTone: tone
	"@message void MSG_CONTACT_EDIT_SET_RINGING_TONE(ContactEditRingingTone tone = cx)"
	^self geosMessage: #[108 5 2 5 1 0] with: tone!

editAddField: type
	"@message void MSG_CONTACT_EDIT_ADD_FIELD(ContdbFieldType type = cx)"
	^self geosMessage: #[108 6 2 5 1 0] with: type!

editAddFieldTypeSelected: type
	"@message void MSG_CONTACT_EDIT_ADD_FIELD_TYPE_SELECTED(ContdbFieldType type = cx)"
	^self geosMessage: #[108 7 2 5 1 0] with: type!

editDeleteField
	"@message void MSG_CONTACT_EDIT_DELETE_FIELD()"
	^self geosMessage: #[108 8 2 0 0]!

editChangeFieldLabel
	"@message void MSG_CONTACT_EDIT_CHANGE_FIELD_LABEL()"
	^self geosMessage: #[108 9 2 0 0]!

editFieldHasFocus: id
	"@message void MSG_CONTACT_EDIT_FIELD_HAS_FOCUS(FieldID id = cx)"
	^self geosMessage: #[108 10 2 5 1 0] with: id!

editInitiateAddFieldDialog
	"@message void MSG_CONTACT_EDIT_INITIATE_ADD_FIELD_DIALOG()"
	^self geosMessage: #[108 11 2 0 0]!

editGetChangeFieldLabelMoniker: list with: entry
	"@message void MSG_CONTACT_EDIT_GET_CHANGE_FIELD_LABEL_MONIKER(optr list = cx:dx, word entry = bp)"
	^self geosMessage: #[108 12 3 245 2 1 0] with: list with: entry!

editChangeLabelOfFocusedField
	"@message void MSG_CONTACT_EDIT_CHANGE_LABEL_OF_FOCUSED_FIELD()"
	^self geosMessage: #[108 13 2 0 0]!

editFieldLabelSelected: type
	"@message void MSG_CONTACT_EDIT_FIELD_LABEL_SELECTED(ContdbFieldType type = cx)"
	^self geosMessage: #[108 14 2 5 1 0] with: type!

editInitiateOptionsDialog
	"@message void MSG_CONTACT_EDIT_INITIATE_OPTIONS_DIALOG()"
	^self geosMessage: #[108 15 2 0 0]!

editMarkModified
	"@message void MSG_CONTACT_EDIT_MARK_MODIFIED()"
	^self geosMessage: #[108 16 2 0 0]!

editCorrectTelHalfLines
	"@message void MSG_CONTACT_EDIT_CORRECT_TEL_HALF_LINES()"
	^self geosMessage: #[108 17 2 0 0]!

editCorrectFaxHalfLines
	"@message void MSG_CONTACT_EDIT_CORRECT_FAX_HALF_LINES()"
	^self geosMessage: #[108 18 2 0 0]!

editAddFieldSpeedDial
	"@message void MSG_CONTACT_EDIT_ADD_FIELD_SPEED_DIAL()"
	^self geosMessage: #[108 19 2 0 0]!

editSaveAndClose
	"@message void MSG_CONTACT_EDIT_SAVE_AND_CLOSE()"
	^self geosMessage: #[108 20 2 0 0]!

editGetRecordHandle
	"@message MemHandle MSG_CONTACT_EDIT_GET_RECORD_HANDLE()=cx"
	^self geosMessage: #[108 21 102 0 1]!

editSetFocusToTopField
	"@message void MSG_CONTACT_EDIT_SET_FOCUS_TO_TOP_FIELD()"
	^self geosMessage: #[108 22 2 0 0]!

editInitiateMenuDialog
	"@message void MSG_CONTACT_EDIT_INITIATE_MENU_DIALOG()"
	^self geosMessage: #[108 23 2 0 0]!

editDisplayNextRecord
	"@message void MSG_CONTACT_EDIT_DISPLAY_NEXT_RECORD()"
	^self geosMessage: #[108 24 2 0 0]!

editDisplayPreviousRecord
	"@message void MSG_CONTACT_EDIT_DISPLAY_PREVIOUS_RECORD()"
	^self geosMessage: #[108 25 2 0 0]!

editCopyRecord
	"@message void MSG_CONTACT_EDIT_COPY_RECORD()"
	^self geosMessage: #[108 26 2 0 0]!

editCopyFieldsToClipboard
	"@message void MSG_CONTACT_EDIT_COPY_FIELDS_TO_CLIPBOARD()"
	^self geosMessage: #[108 27 2 0 0]!

editCorrectTelFaxHalfLines
	"@message void MSG_CONTACT_EDIT_CORRECT_TEL_FAX_HALF_LINES()"
	^self geosMessage: #[108 28 2 0 0]!

editCorrectTelDataHalfLines
	"@message void MSG_CONTACT_EDIT_CORRECT_TEL_DATA_HALF_LINES()"
	^self geosMessage: #[108 29 2 0 0]!

editFetchUrl
	"@message void MSG_CONTACT_EDIT_FETCH_URL()"
	^self geosMessage: #[108 30 2 0 0]!

editSetSelectionToTopField
	"@message void MSG_CONTACT_EDIT_SET_SELECTION_TO_TOP_FIELD()"
	^self geosMessage: #[108 31 2 0 0]!

editInitiateRealOptionsDialog
	"@message void MSG_CONTACT_EDIT_INITIATE_REAL_OPTIONS_DIALOG()"
	^self geosMessage: #[108 32 2 0 0]!

editSetImageName: image
	"@message void MSG_CONTACT_EDIT_SET_IMAGE_NAME(FileLongName *image=cx:dx)"
	^self geosMessage: #[108 33 2 53 3 0] with: image!

editSetRingingToneName: tone
	"@message void MSG_CONTACT_EDIT_SET_RINGING_TONE_NAME(FileLongName *tone=cx:dx)"
	^self geosMessage: #[108 34 2 53 3 0] with: tone!

editShowGroups
	"@message void MSG_CONTACT_EDIT_SHOW_GROUPS()"
	^self geosMessage: #[108 35 2 0 0]!

!

!ContactGroupList comment!
Library contdb, file contdb.goh! !

!ContactGroupList class methodsFor: 'library linkage'!

library
	^16!

entry
	^86!
!

!ContactGroupList methodsFor: 'Geos instance variables'!

cgliStoredGroups
	"@instance optr CGLI_storedGroups"
	^self dwordAt: 34!

cgliStoredGroups: value
	"@instance optr CGLI_storedGroups"
	^self dwordAt: 34 put: value!

cgliDisplayMemberCount
	"@instance word CGLI_displayMemberCount"
	^self wordAt: 38!

cgliDisplayMemberCount: value
	"@instance word CGLI_displayMemberCount"
	^self wordAt: 38 put: value!

!

!ContactGroupList methodsFor: 'Geos vardata'!

!

!ContactGroupList methodsFor: 'Geos messages'!

groupListInit
	"@message void MSG_CONTACT_GROUP_LIST_INIT()"
	^self geosMessage: #[108 0 2 0 0]!

!

!ContactList comment!
Library contdb, file contdb.goh! !

!ContactList class methodsFor: 'library linkage'!

library
	^16!

entry
	^11!
!

!ContactList methodsFor: 'Geos instance variables'!

cliSearchResult
	"@instance VMBlockHandle CLI_searchResult"
	^self wordAt: 25!

cliSearchResult: value
	"@instance VMBlockHandle CLI_searchResult"
	^self wordAt: 25 put: value!

cliTimerID
	"@instance word CLI_timerID"
	^self wordAt: 27!

cliTimerID: value
	"@instance word CLI_timerID"
	^self wordAt: 27 put: value!

cliTimerHandle
	"@instance TimerHandle CLI_timerHandle"
	^self wordAt: 29!

cliTimerHandle: value
	"@instance TimerHandle CLI_timerHandle"
	^self wordAt: 29 put: value!

cliCurItem
	"@instance word CLI_curItem"
	^self wordAt: 31!

cliCurItem: value
	"@instance word CLI_curItem"
	^self wordAt: 31 put: value!

!

!ContactList methodsFor: 'Geos vardata'!

attrContactListMoniker: value
	"@vardata ChunkHandle ATTR_CONTACT_LIST_MONIKER"
	^self addVardata: ##attrContactListMoniker word: value!

attrContactListStatusMsg: value
	"@vardata Message ATTR_CONTACT_LIST_STATUS_MSG"
	^self addVardata: ##attrContactListStatusMsg word: value!

tempContactListTabBounds
	"@vardata Rectangle TEMP_CONTACT_LIST_TAB_BOUNDS"
	^self addVardata: ##tempContactListTabBounds size: 8!

tempContactListTabBounds: aBlock
	"@vardata Rectangle TEMP_CONTACT_LIST_TAB_BOUNDS"
	aBlock value: (GCSRectangle forPointer: (self addVardata: ##tempContactListTabBounds size: 8)).!

tempContactListDoNotSendNotifications
	"@vardata void TEMP_CONTACT_LIST_DO_NOT_SEND_NOTIFICATIONS"
	^self addVardata: ##tempContactListDoNotSendNotifications!

attrContactListCallType: value
	"@vardata ContdbCallType ATTR_CONTACT_LIST_CALL_TYPE"
	^self addVardata: ##attrContactListCallType byte: value!

attrContactListNotifyContactSelectedMsg: value
	"@vardata Message ATTR_CONTACT_LIST_NOTIFY_CONTACT_SELECTED_MSG"
	^self addVardata: ##attrContactListNotifyContactSelectedMsg word: value!

tempContactListSelectedContact: value
	"@vardata RecordID TEMP_CONTACT_LIST_SELECTED_CONTACT"
	^self addVardata: ##tempContactListSelectedContact dword: value!

tempContactListPreserveSearch
	"@vardata void TEMP_CONTACT_LIST_PRESERVE_SEARCH"
	^self addVardata: ##tempContactListPreserveSearch!

attrContactListNumItems: value
	"@vardata word ATTR_CONTACT_LIST_NUM_ITEMS"
	^self addVardata: ##attrContactListNumItems word: value!

hintContactListNonExclusiveList
	"@vardata void HINT_CONTACT_LIST_NON_EXCLUSIVE_LIST"
	^self addVardata: ##hintContactListNonExclusiveList!

attrContactListNotifyNumberEnteredMsg: value
	"@vardata Message ATTR_CONTACT_LIST_NOTIFY_NUMBER_ENTERED_MSG"
	^self addVardata: ##attrContactListNotifyNumberEnteredMsg word: value!

attrContactListEmergencyNumbers: value
	"@vardata ChunkHandle ATTR_CONTACT_LIST_EMERGENCY_NUMBERS"
	^self addVardata: ##attrContactListEmergencyNumbers word: value!

attrContactListAlternateNotifyContactSelectedMsg: value
	"@vardata word ATTR_CONTACT_LIST_ALTERNATE_NOTIFY_CONTACT_SELECTED_MSG"
	^self addVardata: ##attrContactListAlternateNotifyContactSelectedMsg word: value!

attrContactListAlternateNotifyNumberEnteredMsg: value
	"@vardata Message ATTR_CONTACT_LIST_ALTERNATE_NOTIFY_NUMBER_ENTERED_MSG"
	^self addVardata: ##attrContactListAlternateNotifyNumberEnteredMsg word: value!

tempContactListAlternateSelectionMode
	"@vardata void TEMP_CONTACT_LIST_ALTERNATE_SELECTION_MODE"
	^self addVardata: ##tempContactListAlternateSelectionMode!

tempContactListSelectedInfo
	"@vardata ContactListSelectionData TEMP_CONTACT_LIST_SELECTED_INFO"
	^self addVardata: ##tempContactListSelectedInfo size: 10!

tempContactListSelectedInfo: aBlock
	"@vardata ContactListSelectionData TEMP_CONTACT_LIST_SELECTED_INFO"
	aBlock value: (GCSContactListSelectionData forPointer: (self addVardata: ##tempContactListSelectedInfo size: 10)).!

attrContactListNotifyMultipleContactsSelectedMsg: value
	"@vardata Message ATTR_CONTACT_LIST_NOTIFY_MULTIPLE_CONTACTS_SELECTED_MSG"
	^self addVardata: ##attrContactListNotifyMultipleContactsSelectedMsg word: value!

attrContactListAlternateNotifyMultipleContactsSelectedMsg: value
	"@vardata Message ATTR_CONTACT_LIST_ALTERNATE_NOTIFY_MULTIPLE_CONTACTS_SELECTED_MSG"
	^self addVardata: ##attrContactListAlternateNotifyMultipleContactsSelectedMsg word: value!

attrContactListAttachDetailsView
	"@vardata void ATTR_CONTACT_LIST_ATTACH_DETAILS_VIEW"
	^self addVardata: ##attrContactListAttachDetailsView!

attrContactListShowMemoryCard
	"@vardata void ATTR_CONTACT_LIST_SHOW_MEMORY_CARD"
	^self addVardata: ##attrContactListShowMemoryCard!

tempContactListAlternateLineText: value
	"@vardata ChunkHandle TEMP_CONTACT_LIST_ALTERNATE_LINE_TEXT"
	^self addVardata: ##tempContactListAlternateLineText word: value!

attrContactListLimitingGroupId: value
	"@vardata RecordID ATTR_CONTACT_LIST_LIMITING_GROUP_ID"
	^self addVardata: ##attrContactListLimitingGroupId dword: value!

hintContactListDontAddDefaultHints
	"@vardata void HINT_CONTACT_LIST_DONT_ADD_DEFAULT_HINTS"
	^self addVardata: ##hintContactListDontAddDefaultHints!

attrContactListDontAllowRecords: value
	"@vardata MemHandle ATTR_CONTACT_LIST_DONT_ALLOW_RECORDS"
	^self addVardata: ##attrContactListDontAllowRecords word: value!

attrContactListAllowGroupAsCallType
	"@vardata void ATTR_CONTACT_LIST_ALLOW_GROUP_AS_CALL_TYPE"
	^self addVardata: ##attrContactListAllowGroupAsCallType!

hintContactListNoSecondColumn
	"@vardata void HINT_CONTACT_LIST_NO_SECOND_COLUMN"
	^self addVardata: ##hintContactListNoSecondColumn!

!

!ContactList methodsFor: 'Geos messages'!

listQueryEntryMoniker: list with: entry
	"@message void MSG_CONTACT_LIST_QUERY_ENTRY_MONIKER(optr list = cx:dx, word entry = bp)"
	^self geosMessage: #[108 0 3 245 2 1 0] with: list with: entry!

listSelectionChanged
	"@message void MSG_CONTACT_LIST_SELECTION_CHANGED()"
	^self geosMessage: #[108 1 2 0 0]!

listSearchTextLostFocus
	"@message void MSG_CONTACT_LIST_SEARCH_TEXT_LOST_FOCUS()"
	^self geosMessage: #[108 2 2 0 0]!

listGetIdOfSelectedRecord
	"@message dword MSG_CONTACT_LIST_GET_ID_OF_SELECTED_RECORD()"
	^self geosMessage: #[108 3 2 0 2]!

listSearchTextTimeoutMsg
	"@message void MSG_CONTACT_LIST_SEARCH_TEXT_TIMEOUT_MSG()"
	^self geosMessage: #[108 4 2 0 0]!

listQueryNumberListMoniker
	"@message void MSG_CONTACT_LIST_QUERY_NUMBER_LIST_MONIKER()"
	^self geosMessage: #[108 5 2 0 0]!

listSelectCurrentContact
	"@message void MSG_CONTACT_LIST_SELECT_CURRENT_CONTACT()"
	^self geosMessage: #[108 6 2 0 0]!

listSelectContactNumber
	"@message void MSG_CONTACT_LIST_SELECT_CONTACT_NUMBER()"
	^self geosMessage: #[108 7 2 0 0]!

listCloseContactNumberPopup
	"@message void MSG_CONTACT_LIST_CLOSE_CONTACT_NUMBER_POPUP()"
	^self geosMessage: #[108 8 2 0 0]!

listHandleSelectionChangeNotification: selection
	"@message void MSG_CONTACT_LIST_HANDLE_SELECTION_CHANGE_NOTIFICATION(word selection = bp)"
	^self geosMessage: #[108 9 2 7 1 0] with: selection!

listCompleteSearch
	"@message void MSG_CONTACT_LIST_COMPLETE_SEARCH()"
	^self geosMessage: #[108 10 2 0 0]!

listPreserveSearchOnNextLostFocus
	"@message void MSG_CONTACT_LIST_PRESERVE_SEARCH_ON_NEXT_LOST_FOCUS()"
	^self geosMessage: #[108 11 2 0 0]!

listGetIdsOfSelectedRecords
	"@message ContactListSelectedRecordsData MSG_CONTACT_LIST_GET_IDS_OF_SELECTED_RECORDS()= ax:cx"
	^self geosMessage: #[108 12 134 0 2]!

listNotifyContactSelected
	"@message void MSG_CONTACT_LIST_NOTIFY_CONTACT_SELECTED()"
	^self geosMessage: #[108 13 2 0 0]!

listAlternateNotifyContactSelected
	"@message void MSG_CONTACT_LIST_ALTERNATE_NOTIFY_CONTACT_SELECTED()"
	^self geosMessage: #[108 14 2 0 0]!

listCancelContactNumberPopup
	"@message void MSG_CONTACT_LIST_CANCEL_CONTACT_NUMBER_POPUP()"
	^self geosMessage: #[108 15 2 0 0]!

listSetEmergencyNumbers: numbers with: num
	"@message void MSG_CONTACT_LIST_SET_EMERGENCY_NUMBERS( const TCHAR *numbers = cx:dx, word num = bp)"
	^self geosMessage: #[108 16 3 245 3 1 0] with: numbers with: num!

listGetSearchResults
	"@message Handle MSG_CONTACT_LIST_GET_SEARCH_RESULTS()= ax"
	^self geosMessage: #[108 17 98 0 1]!

listSearchTextGainedFocus
	"@message void MSG_CONTACT_LIST_SEARCH_TEXT_GAINED_FOCUS()"
	^self geosMessage: #[108 18 2 0 0]!

listSetAlternateLineText: text
	"@message void MSG_CONTACT_LIST_SET_ALTERNATE_LINE_TEXT(TCHAR *text = cx:dx)"
	^self geosMessage: #[108 19 2 53 3 0] with: text!

listLimitToGroup: record
	"@message void MSG_CONTACT_LIST_LIMIT_TO_GROUP(RecordID *record = dx:bp)"
	^self geosMessage: #[108 20 2 62 3 0] with: record!

listGetGroupLimit
	"@message RecordID MSG_CONTACT_LIST_GET_GROUP_LIMIT()"
	^self geosMessage: #[108 21 2 0 2]!

listDoGroupSearch
	"@message void MSG_CONTACT_LIST_DO_GROUP_SEARCH()"
	^self geosMessage: #[108 22 2 0 0]!

listGetCurrentDbName: buffer
	"@message void MSG_CONTACT_LIST_GET_CURRENT_DB_NAME(TCHAR *buffer = cx:dx)"
	^self geosMessage: #[108 23 2 53 3 0] with: buffer!

listGetSelectionAndDbNames: returnValue
	"@message void MSG_CONTACT_LIST_GET_SELECTION_AND_DB_NAMES(ContactMultipleSelectionWithDBNames *returnValue = cx:dx)"
	^self geosMessage: #[108 24 2 53 3 0] with: returnValue!

listGetVisibleOrderOfSelectedRecord
	"@message sword MSG_CONTACT_LIST_GET_VISIBLE_ORDER_OF_SELECTED_RECORD()= ax"
	^self geosMessage: #[108 25 98 0 4]!

listGetVisibleOrdersOfSelectedRecords
	"@message ContactListSelectedRecordsData MSG_CONTACT_LIST_GET_VISIBLE_ORDERS_OF_SELECTED_RECORDS()= ax:cx"
	^self geosMessage: #[108 26 134 0 2]!

!

!ContactParentGroupList comment!
Library contdb, file contdb.goh! !

!ContactParentGroupList class methodsFor: 'library linkage'!

library
	^16!

entry
	^116!
!

!ContactParentGroupList methodsFor: 'Geos instance variables'!

cpgliRecord
	"@instance RecordID CPGLI_record"
	^self dwordAt: 34!

cpgliRecord: value
	"@instance RecordID CPGLI_record"
	^self dwordAt: 34 put: value!

cpgliHasParents
	"@instance word CPGLI_hasParents"
	^self wordAt: 38!

cpgliHasParents: value
	"@instance word CPGLI_hasParents"
	^self wordAt: 38 put: value!

!

!ContactParentGroupList methodsFor: 'Geos vardata'!

!

!ContactParentGroupList methodsFor: 'Geos messages'!

parentGroupListSetRecordid: rid
	"@message void MSG_CONTACT_PARENT_GROUP_LIST_SET_RECORDID(dword rid=dx:cx)"
	^self geosMessage: #[108 0 2 46 2 0] with: rid!

parentGroupListReset
	"@message void MSG_CONTACT_PARENT_GROUP_LIST_RESET()"
	^self geosMessage: #[108 1 2 0 0]!

!

!ContactSIMEdit comment!
Library contdb, file contsim.goh! !

!ContactSIMEdit class methodsFor: 'library linkage'!

library
	^16!

entry
	^102!
!

!ContactSIMEdit methodsFor: 'Geos instance variables'!

cseiEditedLocation
	"@instance word CSEI_editedLocation"
	^self wordAt: 25!

cseiEditedLocation: value
	"@instance word CSEI_editedLocation"
	^self wordAt: 25 put: value!

!

!ContactSIMEdit methodsFor: 'Geos vardata'!

!

!ContactSIMEdit methodsFor: 'Geos messages'!

simEditDisplayLocation: location
	"@message void MSG_CONTACT_SIM_EDIT_DISPLAY_LOCATION(word location = bp)"
	^self geosMessage: #[108 0 2 7 1 0] with: location!

simEditGetFieldLengths
	"@message ContactSIMEditFieldLengthData MSG_CONTACT_SIM_EDIT_GET_FIELD_LENGTHS()= dx:cx"
	^self geosMessage: #[108 1 166 0 2]!

simEditSaveIfModified
	"@message ContactSIMEditSaveData MSG_CONTACT_SIM_EDIT_SAVE_IF_MODIFIED()= cx:bp"
	^self geosMessage: #[108 2 158 0 2]!

simEditGetNthEmptyLocation: nth
	"@message word MSG_CONTACT_SIM_EDIT_GET_NTH_EMPTY_LOCATION(word nth = cx)= cx"
	^self geosMessage: #[108 3 102 5 1 1] with: nth!

simEditQueryEmptyMoniker: list with: item
	"@message void MSG_CONTACT_SIM_EDIT_QUERY_EMPTY_MONIKER(optr list = cx:dx, word item = bp)"
	^self geosMessage: #[108 4 3 245 2 1 0] with: list with: item!

!

!ContactSIMList comment!
Library contdb, file contsim.goh! !

!ContactSIMList class methodsFor: 'library linkage'!

library
	^16!

entry
	^101!
!

!ContactSIMList methodsFor: 'Geos instance variables'!

csliFlags
	"@instance CSListFlags CSLI_flags"
	^self byteAt: 25!

csliFlags: value
	"@instance CSListFlags CSLI_flags"
	^self byteAt: 25 put: value!

csliCopyProgressOptr
	"@instance optr CSLI_copyProgressOptr"
	^self dwordAt: 26!

csliCopyProgressOptr: value
	"@instance optr CSLI_copyProgressOptr"
	^self dwordAt: 26 put: value!

csliMatchLength
	"@instance word CSLI_matchLength"
	^self wordAt: 30!

csliMatchLength: value
	"@instance word CSLI_matchLength"
	^self wordAt: 30 put: value!

csliTimerHandle
	"@instance hptr CSLI_timerHandle"
	^self wordAt: 32!

csliTimerHandle: value
	"@instance hptr CSLI_timerHandle"
	^self wordAt: 32 put: value!

csliTimerID
	"@instance word CSLI_timerID"
	^self wordAt: 34!

csliTimerID: value
	"@instance word CSLI_timerID"
	^self wordAt: 34 put: value!

csliReserved
	"@instance word CSLI_reserved"
	^self wordAt: 36!

csliReserved: value
	"@instance word CSLI_reserved"
	^self wordAt: 36 put: value!

!

!ContactSIMList methodsFor: 'Geos vardata'!

attrContactSimListCallType: value
	"@vardata ContdbCallType ATTR_CONTACT_SIM_LIST_CALL_TYPE"
	^self addVardata: ##attrContactSimListCallType byte: value!

attrContactSimListStatusMsg: value
	"@vardata Message ATTR_CONTACT_SIM_LIST_STATUS_MSG"
	^self addVardata: ##attrContactSimListStatusMsg word: value!

attrContactSimListNotifyContactSelectedMsg: value
	"@vardata Message ATTR_CONTACT_SIM_LIST_NOTIFY_CONTACT_SELECTED_MSG"
	^self addVardata: ##attrContactSimListNotifyContactSelectedMsg word: value!

attrContactSimListAlternateNotifyContactSelectedMsg: value
	"@vardata Message ATTR_CONTACT_SIM_LIST_ALTERNATE_NOTIFY_CONTACT_SELECTED_MSG"
	^self addVardata: ##attrContactSimListAlternateNotifyContactSelectedMsg word: value!

attrContactSimListNotifyMultipleContactsSelectedMsg: value
	"@vardata Message ATTR_CONTACT_SIM_LIST_NOTIFY_MULTIPLE_CONTACTS_SELECTED_MSG"
	^self addVardata: ##attrContactSimListNotifyMultipleContactsSelectedMsg word: value!

attrContactSimListAlternateNotifyMultipleContactsSelectedMsg: value
	"@vardata Message ATTR_CONTACT_SIM_LIST_ALTERNATE_NOTIFY_MULTIPLE_CONTACTS_SELECTED_MSG"
	^self addVardata: ##attrContactSimListAlternateNotifyMultipleContactsSelectedMsg word: value!

attrContactSimListNotifyNumberEnteredMsg: value
	"@vardata Message ATTR_CONTACT_SIM_LIST_NOTIFY_NUMBER_ENTERED_MSG"
	^self addVardata: ##attrContactSimListNotifyNumberEnteredMsg word: value!

attrContactSimListAlternateNotifyNumberEnteredMsg: value
	"@vardata Message ATTR_CONTACT_SIM_LIST_ALTERNATE_NOTIFY_NUMBER_ENTERED_MSG"
	^self addVardata: ##attrContactSimListAlternateNotifyNumberEnteredMsg word: value!

attrContactSimListEmergencyNumbers: value
	"@vardata ChunkHandle ATTR_CONTACT_SIM_LIST_EMERGENCY_NUMBERS"
	^self addVardata: ##attrContactSimListEmergencyNumbers word: value!

hintContactSimListNonExclusiveList
	"@vardata void HINT_CONTACT_SIM_LIST_NON_EXCLUSIVE_LIST"
	^self addVardata: ##hintContactSimListNonExclusiveList!

hintContactSimListNotifyOnFocusChange
	"@vardata void HINT_CONTACT_SIM_LIST_NOTIFY_ON_FOCUS_CHANGE"
	^self addVardata: ##hintContactSimListNotifyOnFocusChange!

hintContactSimListStartInLocationOrder
	"@vardata void HINT_CONTACT_SIM_LIST_START_IN_LOCATION_ORDER"
	^self addVardata: ##hintContactSimListStartInLocationOrder!

hintContactSimListDoNotDisplayLocationNumbers
	"@vardata void HINT_CONTACT_SIM_LIST_DO_NOT_DISPLAY_LOCATION_NUMBERS"
	^self addVardata: ##hintContactSimListDoNotDisplayLocationNumbers!

tempContactSimListAlternateSelectionMode
	"@vardata void TEMP_CONTACT_SIM_LIST_ALTERNATE_SELECTION_MODE"
	^self addVardata: ##tempContactSimListAlternateSelectionMode!

tempContactSimListAlternateLineText: value
	"@vardata ChunkHandle TEMP_CONTACT_SIM_LIST_ALTERNATE_LINE_TEXT"
	^self addVardata: ##tempContactSimListAlternateLineText word: value!

!

!ContactSIMList methodsFor: 'Geos messages'!

simListGetSelectedLocation
	"@message ContactSIMListSelectedLocationData MSG_CONTACT_SIM_LIST_GET_SELECTED_LOCATION()= cx:ax"
	^self geosMessage: #[108 0 146 0 2]!

simListGetSelectedLocationsList
	"@message ContactSIMListSelectedLocationsListData MSG_CONTACT_SIM_LIST_GET_SELECTED_LOCATIONS_LIST()= cx:ax"
	^self geosMessage: #[108 1 146 0 2]!

simListClearSelectedEntries
	"@message void MSG_CONTACT_SIM_LIST_CLEAR_SELECTED_ENTRIES()"
	^self geosMessage: #[108 2 2 0 0]!

simListCopyContactRecordsToSim: block with: number
	"@message void MSG_CONTACT_SIM_LIST_COPY_CONTACT_RECORDS_TO_SIM( MemHandle block=cx, word number=dx)"
	^self geosMessage: #[108 3 2 53 1 1 0] with: block with: number!

simListCopyListFromContacts: block with: number with: offset
	"@message void MSG_CONTACT_SIM_LIST_COPY_LIST_FROM_CONTACTS( MemHandle block=cx, word number=dx, word offset=bp)"
	^self geosMessage: #[108 4 3 245 1 1 1 0] with: block with: number with: offset!

simListGetNameSortedStatus
	"@message Boolean MSG_CONTACT_SIM_LIST_GET_NAME_SORTED_STATUS()= carry"
	^self geosMessage: #[108 5 2 0 4]!

simListSetNameSortedStatus: nameSorted
	"@message void MSG_CONTACT_SIM_LIST_SET_NAME_SORTED_STATUS( Boolean nameSorted=cx)"
	^self geosMessage: #[108 6 2 5 4 0] with: nameSorted!

simListSetEmergencyNumbers: list with: number
	"@message void MSG_CONTACT_SIM_LIST_SET_EMERGENCY_NUMBERS( word *list=cx:dx, word number=bp)"
	^self geosMessage: #[108 7 3 245 3 1 0] with: list with: number!

simListQueryUserMoniker: list with: position
	"@message void MSG_CONTACT_SIM_LIST_QUERY_USER_MONIKER(optr list=cx:dx, word position=bp)"
	^self geosMessage: #[108 8 3 245 2 1 0] with: list with: position!

simListSearchEntries
	"@message void MSG_CONTACT_SIM_LIST_SEARCH_ENTRIES()"
	^self geosMessage: #[108 9 2 0 0]!

simListSetFocusByLocation: location
	"@message void MSG_CONTACT_SIM_LIST_SET_FOCUS_BY_LOCATION(word location=bp)"
	^self geosMessage: #[108 10 2 7 1 0] with: location!

simListSelectionChanged: current with: number with: flags
	"@message void MSG_CONTACT_SIM_LIST_SELECTION_CHANGED( word current=cx, word number=bp, GenItemGroupStateFlags flags=dl)"
	^self geosMessage: #[108 11 2 253 1 1 1 0] with: current with: number with: flags!

simListNotifyContactSelected
	"@message void MSG_CONTACT_SIM_LIST_NOTIFY_CONTACT_SELECTED()"
	^self geosMessage: #[108 12 2 0 0]!

simListAlternateNotifyContactSelected
	"@message void MSG_CONTACT_SIM_LIST_ALTERNATE_NOTIFY_CONTACT_SELECTED()"
	^self geosMessage: #[108 13 2 0 0]!

simListSelectCurrentContact
	"@message void MSG_CONTACT_SIM_LIST_SELECT_CURRENT_CONTACT()"
	^self geosMessage: #[108 14 2 0 0]!

simListCurSelTimerSendNow
	"@message void MSG_CONTACT_SIM_LIST_CUR_SEL_TIMER_SEND_NOW()"
	^self geosMessage: #[108 15 2 0 0]!

simListCurSelTimerTimeoutMsg
	"@message void MSG_CONTACT_SIM_LIST_CUR_SEL_TIMER_TIMEOUT_MSG()"
	^self geosMessage: #[108 16 2 0 0]!

simListGainedFocus
	"@message void MSG_CONTACT_SIM_LIST_GAINED_FOCUS()"
	^self geosMessage: #[108 17 2 0 0]!

simListLostFocus
	"@message void MSG_CONTACT_SIM_LIST_LOST_FOCUS()"
	^self geosMessage: #[108 18 2 0 0]!

simListSetAlternateLineText: text
	"@message void MSG_CONTACT_SIM_LIST_SET_ALTERNATE_LINE_TEXT(TCHAR *text = cx:dx)"
	^self geosMessage: #[108 19 2 53 3 0] with: text!

!

!SpeedDialControl comment!
Library contdb, file contdb.goh! !

!SpeedDialControl class methodsFor: 'library linkage'!

library
	^16!

entry
	^22!
!

!SpeedDialControl methodsFor: 'Geos instance variables'!

sdciRecordID
	"@instance dword SDCI_recordID"
	^self dwordAt: 25!

sdciRecordID: value
	"@instance dword SDCI_recordID"
	^self dwordAt: 25 put: value!

sdciFieldID
	"@instance word SDCI_fieldID"
	^self wordAt: 29!

sdciFieldID: value
	"@instance word SDCI_fieldID"
	^self wordAt: 29 put: value!

sdciTriggerObject
	"@instance optr SDCI_triggerObject"
	^self dwordAt: 31!

sdciTriggerObject: value
	"@instance optr SDCI_triggerObject"
	^self dwordAt: 31 put: value!

!

!SpeedDialControl methodsFor: 'Geos vardata'!

tempSpeedDialDbHandle: value
	"@vardata VMFileHandle TEMP_SPEED_DIAL_DB_HANDLE"
	^self addVardata: ##tempSpeedDialDbHandle word: value!

!

!SpeedDialControl methodsFor: 'Geos messages'!

dialQueryListEntry
	"@message void MSG_SPEED_DIAL_QUERY_LIST_ENTRY()"
	^self geosMessage: #[108 0 2 0 0]!

dialOpenList
	"@message void MSG_SPEED_DIAL_OPEN_LIST()"
	^self geosMessage: #[108 1 2 0 0]!

dialReplaceEntry
	"@message void MSG_SPEED_DIAL_REPLACE_ENTRY()"
	^self geosMessage: #[108 2 2 0 0]!

dialDisplayContact: recordID
	"@message void MSG_SPEED_DIAL_DISPLAY_CONTACT(RecordID recordID = cx:dx)"
	^self geosMessage: #[108 3 2 53 2 0] with: recordID!

!

